#ifndef MAIN_C
#define MAIN_C

// Global includes
#include <htc.h>

// Local includes
#include "usb.h"
#include "HardwareProfile.h"
#include "usb_function_hid.h"
#include "genericHID.h"
//#include "MyRoutins.h"

// PIC 18F4550 fuse configuration:
// Config word 1 (Oscillator configuration)
// 20Mhz crystal input scaled to 48Mhz and configured for USB operation
__CONFIG(1, USBPLL & IESODIS & FCMDIS & HSPLL & CPUDIV1 & PLLDIV5);
// Config word 2
__CONFIG(2, VREGEN & PWRTDIS & BOREN & BORV20 & WDTDIS & WDTPS32K);
// Config word 3
__CONFIG(3, PBDIGITAL & LPT1DIS & MCLREN);
// Config word 4
__CONFIG(4, XINSTDIS & STVREN & LVPDIS & ICPORTDIS & DEBUGDIS);
// Config word 5, 6 and 7 (protection configuration)
__CONFIG(5, UNPROTECT);
__CONFIG(6, UNPROTECT);
__CONFIG(7, UNPROTECT);

// local prototypes
static void InitialiseSystem(void);
void ProcessIO(void);
void LEDDrive(void);
void I2C_IN_OUT(void);
void ReadRotary(void);
void AD_conv(void);
void ReadPort(void);

#define  testbit(var, bit)  ((var) & (1 <<(bit)))


//unsigned char beolvas, SPD_up, SPD_down, HDG_up, HDG_down, CRS_up, CRS_down, PrevStateA;
//unsigned char ALT_up, ALT_down, VS_up, VS_down, PrevStateC;
//unsigned char FREQ_up, FREQ_down, FREQ_DEC_up, FREQ_DEC_down, PrevStateE;
unsigned char FLAPS; //RC0_2; 

// Main function
void main(void)
{
    InitialiseSystem();

    while(1)
    {
		// Check bus status and service USB interrupts.
        USBDeviceTasks();

		// Application-specific tasks.
        ProcessIO();

		AD_conv();

		ReadPort();

    }
}

// Initialise system
static void InitialiseSystem(void)
{

	// Configure ports as inputs (1) or outputs(0)
	TRISA = 0b00111111;
    ADCON1 = 0b00001010; // AN0-4 analog, tbbi digital I/O
	TRISB = 0b00000011;	//
	TRISC = 0b11000111;
	TRISD = 0b00000000;
	TRISE = 0b00000111;	//

	// Clear all ports
	PORTA = 0b00000000;
	PORTB = 0b00000000;
	PORTC = 0b00000000;
	PORTD = 0b00000000;
	PORTE = 0b00000000;

	_delay(100);

	SSPSTAT=0;		// Disable SMBus inputs
	SMP=0;			// Disable slew rate control
	SSPADD=0x31;	// Copy value to SSPADD (100kHz @ 20 MHz)
	SSPCON1=0x28;
	SSPCON2=0;		// Clear control bits
	SSPIF=0;		// Clear PIR1,SSP interrupt flag
	BCLIF=0;		// Clear PIR2,Bit Collision flag)


    #if defined(USE_SELF_POWER_SENSE_IO)
    tris_self_power = INPUT_PIN;
    #endif
    
    // Initialize the variable holding the handle for the last
    // transmission
    USBOutHandle = 0;
    USBInHandle = 0;

    blinkStatusValid = TRUE;
    
    USBDeviceInit();
}


// Process input and output
void ProcessIO(void)
{   
    // If we are not in the configured state just return
    if((USBDeviceState < CONFIGURED_STATE)||(USBSuspendControl==1)) return;
    
	// We support the following commands:
	//
	// 0x80 

	//Check if data was received from the host.
    if(!HIDRxHandleBusy(USBOutHandle))
    {   
        switch(ReceivedDataBuffer[0])
		{
            case 0x80:  // Toggle the LED
				LATB=ReceivedDataBuffer[2];
				LATD=ReceivedDataBuffer[3];

				ToSendDataBuffer[0] = 0x80;

				// Transmit the response to the host
				if(!HIDTxHandleBusy(USBInHandle))
				{
					USBInHandle = HIDTxPacket(HID_EP,(BYTE*)&ToSendDataBuffer[0],64);
				}
                break;
			
        }
        // Re-arm the OUT endpoint for the next packet
        USBOutHandle = HIDRxPacket(HID_EP,(BYTE*)&ReceivedDataBuffer,64);
    }  
}

void AD_conv(void)
{
	ADCON0=0b00000000; // AN0
	ADCON2=0b10100101;
	ADCON0=0b00000001;
	_delay(20);
	ADCON0=0b00000011;
	do {} while(testbit(ADCON0,1)!=0);
	ToSendDataBuffer[1] = ADRESL;
	ToSendDataBuffer[2] = ADRESH;
	ADCON0=0b00000000;	

	ADCON0=0b00000100; // AN1
	ADCON2=0b10100101;
	ADCON0=0b00000101;
	_delay(20);
	ADCON0=0b00000111;
	do {} while(testbit(ADCON0,1)!=0);
	ToSendDataBuffer[3] = ADRESL;
	ToSendDataBuffer[4] = ADRESH;
	ADCON0=0b00000100;	

	ADCON0=0b00001000; // AN2
	ADCON2=0b10100101;
	ADCON0=0b00001001;
	_delay(20);
	ADCON0=0b00001011;
	do {} while(testbit(ADCON0,1)!=0);
	ToSendDataBuffer[5] = ADRESL;
	ToSendDataBuffer[6] = ADRESH;
	ADCON0=0b00001000;	

	ADCON0=0b00001100; // AN3
	ADCON2=0b10100101;
	ADCON0=0b00001101;
	_delay(20);
	ADCON0=0b00001111;
	do {} while(testbit(ADCON0,1)!=0);
	ToSendDataBuffer[7] = ADRESL;
	ToSendDataBuffer[8] = ADRESH;
	ADCON0=0b00001100;	

	ADCON0=0b00010000; // AN4
	ADCON2=0b10100101;
	ADCON0=0b00010001;
	_delay(20);
	ADCON0=0b00010011;
	do {} while(testbit(ADCON0,1)!=0);
	ToSendDataBuffer[9] = ADRESL;
	ToSendDataBuffer[10] = ADRESH;
	ADCON0=0b00010000;	
}


void ReadPort(void)
{
	//FLAPS = LATE;
	FLAPS=0;
	if (RE0=1) FLAPS=1;
	if (RE1=1) FLAPS=FLAPS+2;
	if (RE2=1) FLAPS=FLAPS+4;
	if (RA4=1)FLAPS=8;
	ToSendDataBuffer[11] = FLAPS;

	//if (RC0=1) RC0_2=1;
	//else RC0_2=0;
	//if (RC1=1) RC0_2=RC0_2+2;
	//if (RC2=1) RC0_2=RC0_2+4;
	ToSendDataBuffer[12] = LATC;
}

#endif
